#!/usr/bin/perl

my $filenamepath = "/tmp/com.vara.automator.screenflowrecorderfile.txt";
system("unlink $filenamepath 2> /dev/null");

my $scratch = "/tmp/scratch.txt";

# accept any kind of text input (mac/unix...)
my @lines = split(/\012\015?|\015\012?/,(join '',<STDIN>));

my $cam = "";
my $mic = "";
my $snd = "";
my $dsk = "";
my $app = "/Applications/ScreenFlow.app";
my $file = "";

foreach (@lines) {
	my	@words	=	split(/\t/);
	my	$type	=	lc trim(@words[0]);
	my	$id		=	"";
	my	$count	=	@words;
	
	if ($count > 1) {
		$id		=	"\"" . @words[1] . "\"";
	}
		
	if ($type =~ /desktop/) {
		$dsk	=	"-desktop $id";
	}
	
	if ($type =~ /cam/) {
		$cam	=	"-camera $id";
	}
	
	if ($type =~ /mic/) {
		$mic	=	"-microphone $id";
	}
	
	if ($type =~ /app/) {
		if ($id =~ /.app/) {
			$app	=	@words[1];
		}
		else {
			$app	=	@words[1] . ".app";
		}
	}
	
	if ($type =~ /filepath/) {
		system("echo $id > $filenamepath");
		$file = $id;
	}
	
	$id = lc $id;
	if ($type =~ /speakers/) {
		$snd = "-speakers";
	}
}

#print "\"$app/Contents/Resources/screenflowrecorder\" $snd $dsk $cam $mic $file\n";

if (system("\"$app/Contents/Resources/screenflowrecorder\" $snd $dsk $cam $mic $file  > /dev/null 2>&1 &") == 0) {
	print "OK";
}
else  {
	print "FAILED: \"$app/Contents/Resources/screenflowrecorder\" $snd $dsk $cam $mic $file\n";
	exit -1;
}

#open(OUTPUT, ">$scratch") || die "Cannot open input '$scratch' $!";
#print OUTPUT "$app/Contents/Resources/screenflowrecorder $snd $dsk $cam $mic $file\n";

sub trim 
{
    my @out = @_;
    for (@out) 
    {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}
